"use strict";
/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Jobs = void 0;
const fineTuningJobsCancel_js_1 = require("../funcs/fineTuningJobsCancel.js");
const fineTuningJobsCreate_js_1 = require("../funcs/fineTuningJobsCreate.js");
const fineTuningJobsGet_js_1 = require("../funcs/fineTuningJobsGet.js");
const fineTuningJobsList_js_1 = require("../funcs/fineTuningJobsList.js");
const fineTuningJobsStart_js_1 = require("../funcs/fineTuningJobsStart.js");
const sdks_js_1 = require("../lib/sdks.js");
const fp_js_1 = require("../types/fp.js");
class Jobs extends sdks_js_1.ClientSDK {
    /**
     * Get Fine Tuning Jobs
     *
     * @remarks
     * Get a list of fine-tuning jobs for your organization and user.
     */
    async list(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, fineTuningJobsList_js_1.fineTuningJobsList)(this, request, options));
    }
    /**
     * Create Fine Tuning Job
     *
     * @remarks
     * Create a new fine-tuning job, it will be queued for processing.
     */
    async create(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, fineTuningJobsCreate_js_1.fineTuningJobsCreate)(this, request, options));
    }
    /**
     * Get Fine Tuning Job
     *
     * @remarks
     * Get a fine-tuned job details by its UUID.
     */
    async get(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, fineTuningJobsGet_js_1.fineTuningJobsGet)(this, request, options));
    }
    /**
     * Cancel Fine Tuning Job
     *
     * @remarks
     * Request the cancellation of a fine tuning job.
     */
    async cancel(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, fineTuningJobsCancel_js_1.fineTuningJobsCancel)(this, request, options));
    }
    /**
     * Start Fine Tuning Job
     *
     * @remarks
     * Request the start of a validated fine tuning job.
     */
    async start(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, fineTuningJobsStart_js_1.fineTuningJobsStart)(this, request, options));
    }
}
exports.Jobs = Jobs;//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/b5a41840a0ce29fe5a86b2fa07c26b07f92684d2/node_modules/@mistralai/mistralai/sdk/jobs.js.map