export default function once(emitter, name, { signal } = {}) {
    return new Promise((resolve, reject) => {
        function cleanup() {
            signal === null || signal === void 0 ? void 0 : signal.removeEventListener('abort', cleanup);
            emitter.removeListener(name, onEvent);
            emitter.removeListener('error', onError);
        }
        function onEvent(...args) {
            cleanup();
            resolve(args);
        }
        function onError(err) {
            cleanup();
            reject(err);
        }
        signal === null || signal === void 0 ? void 0 : signal.addEventListener('abort', cleanup);
        emitter.on(name, onEvent);
        emitter.on('error', onError);
    });
}//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/b5a41840a0ce29fe5a86b2fa07c26b07f92684d2/node_modules/@tootallnate/once/dist/index.js.map