"use strict";
/*
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Models = void 0;
const modelsArchive_js_1 = require("../funcs/modelsArchive.js");
const modelsDelete_js_1 = require("../funcs/modelsDelete.js");
const modelsList_js_1 = require("../funcs/modelsList.js");
const modelsRetrieve_js_1 = require("../funcs/modelsRetrieve.js");
const modelsUnarchive_js_1 = require("../funcs/modelsUnarchive.js");
const modelsUpdate_js_1 = require("../funcs/modelsUpdate.js");
const sdks_js_1 = require("../lib/sdks.js");
const fp_js_1 = require("../types/fp.js");
class Models extends sdks_js_1.ClientSDK {
    /**
     * List Models
     *
     * @remarks
     * List all models available to the user.
     */
    async list(options) {
        return (0, fp_js_1.unwrapAsync)((0, modelsList_js_1.modelsList)(this, options));
    }
    /**
     * Retrieve Model
     *
     * @remarks
     * Retrieve a model information.
     */
    async retrieve(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, modelsRetrieve_js_1.modelsRetrieve)(this, request, options));
    }
    /**
     * Delete Model
     *
     * @remarks
     * Delete a fine-tuned model.
     */
    async delete(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, modelsDelete_js_1.modelsDelete)(this, request, options));
    }
    /**
     * Update Fine Tuned Model
     *
     * @remarks
     * Update a model name or description.
     */
    async update(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, modelsUpdate_js_1.modelsUpdate)(this, request, options));
    }
    /**
     * Archive Fine Tuned Model
     *
     * @remarks
     * Archive a fine-tuned model.
     */
    async archive(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, modelsArchive_js_1.modelsArchive)(this, request, options));
    }
    /**
     * Unarchive Fine Tuned Model
     *
     * @remarks
     * Un-archive a fine-tuned model.
     */
    async unarchive(request, options) {
        return (0, fp_js_1.unwrapAsync)((0, modelsUnarchive_js_1.modelsUnarchive)(this, request, options));
    }
}
exports.Models = Models;//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/b5a41840a0ce29fe5a86b2fa07c26b07f92684d2/node_modules/@mistralai/mistralai/sdk/models.js.map